package cn.com.duiba.cloud.manage.service.api.model.param.report;

import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 业务方报表
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class BusinessReportParam implements Serializable {

    private static final long serialVersionUID = 5696711053559590377L;

    /**
     * 统计日期
     */
    @NotNull(message = "统计日期不能为空")
    private Date date;

    /**
     * 省代码
     */
    private String provinceCode;
    /**
     * 省份名称
     */
    private String provinceName;

    /**
     * 租户ID
     */
    private Long tenantId;

    /**
     * 登录用户id
     */
    private Long innerUserId;
}
