package cn.com.duiba.cloud.manage.service.api.model.param.report;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 新增活动复盘
 *
 * @author xuanhongjian
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SaveActivityParam implements Serializable {

    private static final long serialVersionUID = 1102718850533441228L;

    private Long id;


    /**
     * 活动名称
     */
    @NotNull(message = "活动名称")
    private String activityName;
    /**
     * 活动版块归属
     */
    private String activityBelong;
    /**
     * 活动开始结束时间
     */
    private String startEndTime;
    /**
     * 需求来源
     */
    private String demandSource;
    /**
     * 零售户入网户数（万户）
     */
    private Long retailerUser;
    /**
     * 公众号关注量 万
     */
    private Long wechatFollowUser;

    /**
     * 零售户活动交互（万户次）
     */
    private Long retailerActivityPv;
    /**
     * 消费者活动交互（万人次）
     */
    private Long consumerActivityPv;
    /**
     * 推文宣传交互阅读量（万人次）
     */
    private Long wechatReadPv;
}
