package cn.com.duiba.cloud.manage.service.api.model.dto.plan;

import cn.com.duiba.cloud.manage.service.api.model.dto.elasticsearch.RemoteEsBaseDto;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author xuanyu
 * @description: 推文计划信息
 * @date 2022/11/15 3:48 PM
 */
@Data
public class TweetsPlanDTO extends RemoteEsBaseDto implements Serializable {

    private static final long serialVersionUID = -6140071203654793528L;

    /**
     * 推文计划id
     */
    private Long tweetsPlanId;

    /**
     * 标题
     */
    private String title;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 推文顺序
     */
    private Integer pushOrder;

    /**
     * 主题内容
     */
    private String mainContent;

    /**
     * 活动物料
     */
    private String activeMaterial;

    /**
     * 目标阅读量
     */
    private BigDecimal targetReading;

    /**
     * 形式
     */
    private String form;

    /**
     * 待办id
     */
    private Long upcomingId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动板块
     */
    private Long activityTemplate;

    /**
     * 运营计划id
     */
    private Long operatePlanId;

    /**
     * 品规信息
     */
    private List<TweetsRegulateDTO> regulateList;

    /**
     * 计划负责人
     */
    private List<TweetsDutyPersonDTO> dutyPersonList;

    /**
     * 部门
     */
    private List<TweetsDepartmentDTO> departmentList;
}
