package cn.com.duiba.cloud.manage.service.api.remoteservice.plan;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.*;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.*;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.*;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.RemoteDateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.RemoteYearPlanQueryParam;

import java.util.List;

/**
 * @Description
 * @Date 2022/9/13 17:34
 * @Author LuHui
 */
@AdvancedFeignClient
public interface RemotePlanService {

    /**
     * 保存数据
     *
     * @param list
     */
    void batchSaveDataToEs(List<RemoteEsPlanDto> list);

    /**
     * 批量更新数据
     *
     * @param list
     */
    void batchUpdateDataToEs(List<RemoteEsPlanDto> list);

    /**
     * 批量删除
     * @param list
     */
    void batchDeleteDataToEs(List<RemoteEsPlanDto> list);

    /**
     * 创建计划
     *
     * @param remotePlanDto
     * @return
     * @throws BizException
     */
    Long create(RemotePlanDto remotePlanDto) throws BizException;

    /**
     * 编辑计划
     *
     * @param remotePlanDto
     * @return
     * @throws BizException
     */
    Boolean edit(RemotePlanDto remotePlanDto) throws BizException;

    /**
     * 编辑数据回流
     * @param remotePlanDto
     * @return
     */
    Boolean editData(RemotePlanDto remotePlanDto) throws BizException;

    /**
     * 删除计划
     * @param id
     * @return
     * @throws BizException
     */
    Boolean delete(Long id) throws BizException;

    /**
     * 计划详情
     * @param id
     * @return
     * @throws BizException
     */
    RemotePlanDto selectById(Long id) throws BizException;

    /**
     * 面板统计
     * @param param
     * @return
     * @throws Exception
     */
    List<RemotePlanStatisticsDto> queryStatistics(RemoteDateParam param) throws Exception;

    /**
     * 条件查询年度计划
     * @param param
     * @return
     * @throws Exception
     */
    List<RemoteYearPlanDto> pageListYearPlan(RemoteYearPlanQueryParam param) throws Exception;

    /**
     * 年度计划总览
     * @param param
     * @return
     */
    List<RemoteYearPlanReviewStatisticsDto> statisticsYearPlanReview(RemoteDateParam param);

    /**
     * 数据回流统计
     * @param id
     * @return
     */
    RemotePlanDataStatisticsVo queryDataStatistics(Long id) throws BizException;

    /**
     * 保存修改明细
     *
     * @param remoteUpdatePlanRecordParam
     * @return
     */
    Boolean saveUpdateDetail(RemoteUpdatePlanRecordParam remoteUpdatePlanRecordParam);

    /**
     * 获取修改明细记录
     *
     * @param param
     * @return
     */
    PageResponse<RemoteUpdateRecordDto> updateDetailRecord(RemotePlanRecordQueryParam param);

    /**
     * 资料库列表
     *
     * @param param
     * @return
     */
    PageResponse<RemoteDataBaseDetailDto> dataList(RemotePlanRecordQueryParam param);

    /**
     * 查询物资
     *
     * @param param
     * @return
     */
    PageResponse<RemoteMaterialDetailDto> queryMaterial(RemotePlanRecordQueryParam param) throws BizException;

    /**
     * 保存更新物资
     *
     * @param param
     * @return
     */
    Boolean insertOrUpdateMaterial(RemotePlanMaterialParam param) throws BizException;

    /**
     * 删除物资
     *
     * @return
     */
    Boolean deleteMaterial( Long id,String userId,String newContext) throws BizException;

    Boolean deleteData(Long planId, Long id,String userId) throws BizException;

    /**
     * 保存资料
     *
     * @param param
     * @return
     */
    Boolean saveData(RemoteSavePlanDataParam param);


    /**
     * 开启关闭计划
     * @param id
     * @return
     */
    Boolean openClose(Long id,String jobNo,String name) throws BizException;

    /**
     * 改变计划状态
     * @param id
     * @return
     */
    Boolean changePlanStatus(Long id,String jobNo,String name) throws BizException;

    /**
     * 查询计划流程进度
     * @param id
     * @return
     */
    RemotePlanProgressDto queryProgress(Long id) throws BizException;




}
