package cn.com.duiba.cloud.manage.service.api.remoteservice.punch;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.punch.PunchDataTrendDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.punch.PunchDataViewDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.punch.PunchManagerAnswerDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.punch.PunchManagerDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.punch.RemoteActivityDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.punch.RemotePunchDateTrendParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author xuanyu
 * @description:
 * @date 2022/8/18 3:33 PM
 */
@AdvancedFeignClient
public interface RemoteManagerPunchService {
    /**
     * 活动中心-详情
     * @param remoteActivityDetailParam
     * @return
     */
    PageResponse<PunchManagerDetailDTO> detail(RemoteActivityDetailParam remoteActivityDetailParam);

    /**
     * 查看答卷
     * @param recordId 打卡总表记录id
     * @return
     */
    List<PunchManagerAnswerDetailDTO> getAnswerDetail(Long recordId) throws BizException;



    /**
     * 数据预览
     * @param activityId
     * @return
     */
    PunchDataViewDTO dataView(Long activityId);

    /**
     * 数据趋势
     * @param remotePunchDateTrendParam
     * @return
     */
    PunchDataTrendDTO dataTrend(RemotePunchDateTrendParam remotePunchDateTrendParam);
}
