package cn.com.duiba.cloud.manage.service.api.remoteservice.terminal;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.RetailerProgressPageDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.TerminalReportRecordDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteReportRetailerQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteTerminalReportPageQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteTerminalReportRecordDeleteParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteTerminalReportRecordSaveParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteTerminalReportRecordUpdateParam;
import cn.com.duiba.wolf.entity.PageResponse;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
* @author yuanzhixin
* @version 1.0
* @date 2022-05-26 10:38:03
*/
@AdvancedFeignClient
public interface RemoteTerminalReportRecordService {


    /**
     * 查询上报情况
     * @param activityId 活动id
     * @param terminalId 终端业务员id list
     * @param retailerIdList 零售户id list
     * @return List<TerminalReportRecordDTO>
     */
    List<TerminalReportRecordDTO> queryByRetailerList(@NotNull(message = "活动id不能为空") Long activityId,
                                                      Long terminalId,
                                                      @NotEmpty(message = "零售户id list不能为空") List<Long> retailerIdList);

    /**
     * 批量保存零售户上报记录
     * @param param 保存、修改参数
     */
    void batchSave(RemoteTerminalReportRecordSaveParam param);

    /**
     * 查询终端业务员已上报情况
     * @param activityId 活动id
     * @param terminalId 终端业务员id list
     * @return List<TerminalReportRecordDTO>
     */
    List<TerminalReportRecordDTO> queryByTerminal(@NotNull(message = "活动id不能为空") Long activityId,
                                                  @NotNull(message = "终端业务员id不能为空") Long terminalId);

    /**
     * 分页查询已上报的零售户信息
     * @param remoteParam 查询参数
     * @return PageResponse<RetailerProgressPageDTO>
     */
    PageResponse<RetailerProgressPageDTO> pageByTerminal(RemoteTerminalReportPageQueryParam remoteParam);

    /**
     * 根据条件查询零售户上报情况
     * @param param 查询参数
     * @return List<TerminalReportRecordDTO>
     */
    List<TerminalReportRecordDTO> queryRetailerByParam(RemoteReportRetailerQueryParam param);

    /**
     * 根据条件修改
     * @param param 参数
     */
    void updateByParam(RemoteTerminalReportRecordUpdateParam param) throws BizException;

    /**
     * 根据条件修改
     * @param param 参数
     */
    void deleteByParam(RemoteTerminalReportRecordDeleteParam param) throws BizException;
}
