package cn.com.duiba.cloud.manage.service.api.model.dto.dept;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 部门信息DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-09-19 13:36
 * @since 2.0.8
 **/
@Data
public class DeptInfoDTO implements Serializable {
    private static final long serialVersionUID = 997370352087480351L;

    /**
     * 主键（部门id）
     */
    private Long id;

    /**
     * 部门名称
     */
    private String name;

    /**
     * 父级部门id
     */
    private Long parentId;

    /**
     * 部门路径
     */
    private String deptPath;

    /**
     * 部门描述
     */
    private String deptDesc;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 钉钉部门id
     */
    private Long dingDeptId;

    /**
     * 部门类型（1：后台新建部门，2：钉钉同步部门）
     */
    private Integer deptType;

    /**
     * 租户id
     */
    private Long tenantId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 创建者
     */
    private Long createdBy;

    /**
     * 修改者
     */
    private Long modifiedBy;
}
