package cn.com.duiba.cloud.manage.service.api.model.dto.staff;

import cn.com.duiba.cloud.manage.service.api.model.enums.system.AccountTypeEnum;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * @author linzhou
 * @ClassName StaffListVo.java
 * @createTime 2021年11月02日 11:33:00
 * @Description
 */
@Getter
@Setter
public class StaffDTO implements Serializable {

    private Long id;

    /**
     * 内部用户id
     */
    private Long innerUserId;

    /**
     * 员工名称
     */
    private String staffName;
    /**
     * 人员手机号码
     */
    private String mobile;
    /**
     * 员工编号
     */
    private String userId;
    /**
     * 岗位名称
     */
    private String positionName;
    /**
     * 角色
     */
    private String roleNames;
    private List<Long> roleIds;
    /**
     * 部门
     */
    private String deptName;
    /**
     * 身份 0:管理员 1:普通员工
     */
    private Integer identify;
    /**
     * 部门身份描述
     */
    private String deptIdentifyDesc;
    /**
     * 部门身份
     */
    private Integer deptIdentify;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 备注
     */
    private String remark;

    /**
     * 账号类型（1:外部账号，2：企业员工）
     *
     * @see AccountTypeEnum
     */
    private Integer accountType;

    /**
     * 是否启用
     */
    private Integer isEnable;
}
