package cn.com.duiba.cloud.manage.service.api.model.dto.supplier;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 苏宁订单状态
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/18
 */
@Getter
@Setter
public class SuningOrderStatusDTO implements Serializable {

    private static final long serialVersionUID = -5153933563145605746L;
    /**
     * 订单号
     */
    private String orderId;

    /**
     * 订单状态。1:审核中; 2:待发货; 3:待收货或待服务; 4:已完成或已服务; 5:已取消; 6:已退货; 7:待处理; 8：审核不通过，订单已取消; 9：待支付
     */
    private String orderStatus;

    /**
     * 子单信息
     */
    private List<SuningOrderItemStatusDTO> orderItemInfoList;

}
