package cn.com.duiba.cloud.manage.service.api.model.param.consumerinfo;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 保存客户信息
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/7
 */
@Data
public class RemoteConsumerInfoConfigSaveParam implements Serializable {

    private static final long serialVersionUID = 3988948200963861652L;

    /**
     * 信息类型
     */
    @NotBlank(message = "信息类型不能为空")
    private String infoType;

    /**
     * 信息标题
     */
    @NotBlank(message = "信息标题不能为空")
    private String infoTopic;

    /**
     * 信息题目
     */
    @NotBlank(message = "信息题目不能为空")
    private String infoContent;

    /**
     * 操作人
     */
    @NotNull(message = "未知操作人")
    private Long operator;

}
