package cn.com.duiba.cloud.manage.service.api.model.param.terminal;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/7/4 13:59
 **/
@Getter
@Setter
public class RemoteReportRetailerQueryParam implements Serializable {

    /**
     * 活动id
     */
    @NotNull(message = "活动id不能为空")
    private Long activityId;

    /**
     * 业务员id
     */
    private Long terminalId;

    /**
     * 零售户id
     */
    private Long retailerId;

    /**
     * 状态
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.terminal.QualificationEnum
     */
    private Integer state;

    /**
     * 审核状态
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.audit.AuditStateEnum#REVIEW
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.audit.AuditStateEnum#PASS
     */
    private Integer auditState;

}
