package cn.com.duiba.cloud.manage.service.api.model.dto.plan.approval;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 审批流配置
 * @Date 2022/11/8 16:19
 * @Author LuHui
 */
@Data
public class ApprovalFlowConfigDto implements Serializable {
    private static final long serialVersionUID = 2570180076264786232L;
    /**
     * 流程节点id
     */
    private Integer id;
    /**
     * 角色 0: 审批人 1:抄送人
     */
    private Integer roleType;
    /**
     * 环节名称
     */
    private String name;
    /**
     * 审批/抄送人
     */
    private List<StaffInfoDto> approvalList;
    /**
     * 审核方式 0:会签 1:或签
     */
    private Integer approvalType;
    /**
     * 签名  0:复用已有 1:重新签名 2:无需签名
     */
    private Integer signType;
    /**
     * 审批发起是否添加抄送 0:是 1:否
     */
    private String sendType;
}
