package cn.com.duiba.cloud.manage.service.api.model.dto.report;

import lombok.Data;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * @author xuanyu
 * @description: 平和星余额
 * @date 2022/7/18 2:57 PM
 */
@Data
public class PeaceRemainReportDTO implements Serializable {
    private static final long serialVersionUID = -970301028121263600L;
    /**
     * 报表明细
     */
    private List<PeaceRemainReportDetailDTO> reportList = Collections.emptyList();

    /**
     * T-1 小于等于600
     */
    private Long preUnderSixHundred;

    /**
     * T-1 小于等于1200
     */
    private Long preUnderOneThousndTwoHundred;

    /**
     * T-1 小于等于1800
     */
    private Long preUnderOneThousandEightHundred;

    /**
     * T-1 小于等于2400
     */
    private Long preUnderTwoThousandFourHundred;

    /**
     * T-1 小于等于3000
     */
    private Long preUnderThreeThousand;

    /**
     * T-1 小于等于3600
     */
    private Long preUnderThreeThousandSixHundred;

    /**
     * T-1 大于3600
     */
    private Long preAboveThreeThousandSixHundred;

    /**
     * 当前累计小于等于600
     */
    private Long currentUnderSixHundred;

    /**
     * 当前累计小于等于1200
     */
    private Long currentUnderOneThousndTwoHundred;

    /**
     * 当前累计小于等于1800
     */
    private Long currentUnderOneThousandEightHundred;

    /**
     * 当前累计小于等于2400
     */
    private Long currentUnderTwoThousandFourHundred;

    /**
     * 当前累计小于等于3000
     */
    private Long currentUnderThreeThousand;

    /**
     * 当前累计小于等于3600
     */
    private Long currentUnderThreeThousandSixHundred;

    /**
     * 当前累计大于3600
     */
    private Long currentAboveThreeThousandSixHundred;
}
