package cn.com.duiba.cloud.manage.service.api.model.enums.plan;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @Author: nongfu
 * @Date: 2022/11/11-14:37
 * @Description:
 */
@Getter
@NoArgsConstructor
@AllArgsConstructor
public enum ApprovalMonthEnum {
    //没有
    NO(0, "-"),
    //全部审批完成
    ALL(1, "已完成"),
    //部分完成
    SOME(2, "★");


    private Integer type;

    private String desc;

    public static ApprovalMonthEnum getByType(Integer type){
        return Stream.of(ApprovalMonthEnum.values()).filter(x -> Objects.equals(x.getType(), type))
                .findFirst().orElse(NO);
    }
}
