package cn.com.duiba.cloud.manage.service.api.model.dto.report.export;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Date 2022/8/19 16:41
 * @Author LuHui
 */
@Data
public class ExportTetailerData implements Serializable {
    private static final long serialVersionUID = 1945413314060729217L;


    /**
     * 开发者端用户ID
     */
    @ExcelProperty("openId")
    private String partnerUserId;
    /**
     * 头像
     */
    @ExcelProperty("用户头像")
    private String avatar;

    /**
     * 昵称
     */
    @ExcelProperty("用户名称")
    private String nickname;

    /**
     * 电话号码
     */
    @ExcelProperty("手机号")
    private String phone;

    /**
     * 姓名
     */
    @ExcelProperty("姓名")
    private String name;

    /**
     * 店铺名称
     */
    @ExcelProperty("店铺名称")
    private String shopName;

    /**
     * 详细地址
     */
    @ExcelProperty("详细地址")
    private String address;


    /**
     * 所属地区
     */
    @ExcelProperty("所属地区")
    private String place;

    /**
     * 专卖证号
     */
    @ExcelProperty("专卖证号")
    private String saleCertificateNo;

    /**
     * 有效期开始
     */
    @ExcelProperty("有效期开始")
    private Date startTime;

    /**
     * 有效期结束
     */
    @ExcelProperty("有效期开始")
    private Date endTime;

    /**
     * 是否是组长 1:是 0:不是
     */
    @ExcelProperty("是否为组长店")
    private String groupLeader;

    /**
     * 业态类型
     */
    @ExcelProperty("业务类型")
    private String type;

    /**
     * 订阅
     */
    @ExcelProperty("关注状态")
    private String subscribeStatus;

}
