package cn.com.duiba.cloud.manage.service.api.model.enums.plan;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @Description 审批单系统类别
 * @Date 2022/11/4 16:35
 * @Author LuHui
 */
public enum ApprovalSystemTypeEnum {
    TYPE_ONE(1, "互联网营销系统"),
    TYPE_TWO(2, "测试选项1"),
    TYPE_THREE(3, "测试选项2"),


    ;

    private Integer id;

    private String name;

    ApprovalSystemTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static ApprovalSystemTypeEnum getById(Integer id){
        if (Objects.isNull(id)){
            return null;
        }
        return Stream.of(ApprovalSystemTypeEnum.values()).filter(x -> Objects.equals(x.getId(), id)).findFirst().orElse(null);
    }
}
