package cn.com.duiba.cloud.manage.service.api.remoteservice.consumerinfo;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.consumerinfo.ConsumerInfoDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.consumerinfo.RemoteConsumerInfoBatchHandleParam;
import cn.com.duiba.cloud.manage.service.api.model.param.consumerinfo.RemoteConsumerInfoQueryParam;

/**
 * 远程个人信息服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/12
 */
@AdvancedFeignClient
public interface RemoteConsumerInfoService {

    /**
     * 查询客户信息内容
     *
     * @param remoteParam 参数
     * @return 具体信息
     * @throws BizException
     */
    ConsumerInfoDTO queryConsumerInfo(RemoteConsumerInfoQueryParam remoteParam) throws BizException;

    /**
     * 批量处理客户信息
     *
     * @param remoteParam 参数
     * @throws BizException
     */
    void batchHandleConsumerInfo(RemoteConsumerInfoBatchHandleParam remoteParam) throws BizException;

}
