package cn.com.duiba.cloud.manage.service.api.remoteservice.plan.approval;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.approval.RemoteApprovalPageSheetDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.approval.RemoteApprovalSheetExportDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.approval.RemoteApprovalDetailDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.approval.RemoteApprovalPageInfoDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.approval.RemoteSheetDraftDto;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.approval.RemoteApprovalPageSheetParam;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.approval.RemoteApprovalSheetParam;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.approval.RemoteCommentParam;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.approval.RemoteDealApprovalParam;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.approval.RemoteReApprovalSheetParam;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.approval.RemoteSheetDraftParam;
import cn.com.duiba.wolf.entity.PageRequest;
import cn.com.duiba.wolf.entity.PageResponse;
import com.alibaba.fastjson.JSONObject;

import java.util.List;


/**
 * @Description 审批单
 * @Date 2022/11/4 16:44
 * @Author LuHui
 */
@AdvancedFeignClient
public interface RemoteApprovalSheetService {

    /**
     * 分页查询审批单
     * @param planId
     * @param userId
     * @return
     * @throws BizException
     */
    List<RemoteApprovalPageInfoDto> pageList(Long planId, String userId) throws BizException;

    /**
     * 查询审批单
     * @param planId
     * @param userId
     * @return
     * @throws BizException
     */
    List<RemoteApprovalPageInfoDto> queryList(Long planId, String userId) throws BizException;


    /**
     * 查询全部已发起的审批单
     * @param approvalSheetIdList
     * @param planId
     * @return
     */
    List<RemoteApprovalSheetExportDto>  queryAllCreateApprovalSheet(Long planId, List<Long> approvalSheetIdList);

    /**
     * 创建审批单
     * @param param
     * @return
     * @throws BizException
     */
    Boolean create(RemoteApprovalSheetParam param) throws BizException;

    /**
     * 重发审批单
     * @param param
     * @return
     * @throws BizException
     */
    Boolean reCreate(RemoteReApprovalSheetParam param) throws BizException;

    /**
     * 暂存草稿
     * @param param
     * @return
     * @throws BizException
     */
    Boolean stageDraft(RemoteSheetDraftParam param) throws BizException;

    /**
     * 查询草稿
     * @param planId
     * @param approvalFlowId
     * @return
     */
    RemoteSheetDraftDto getDraft(Long planId, Long approvalFlowId);

    /**
     * 评论
     * @param param
     * @return
     */
    Boolean comment(RemoteCommentParam param) throws BizException;
    /**
     * 查看审批单
     * @param id
     * @return
     */
    RemoteApprovalDetailDto queryApproval(Long id ,String userId);
    /**
     * 审核
     * @param dealApprovalParam
     * @return
     */
    Boolean dealApproval(RemoteDealApprovalParam dealApprovalParam) throws BizException;

    /**
     * 判断是否是计划负责人
     * @param userId
     * @param planId
     * @return
     * @throws BizException
     */
    Boolean judgeIsDutyPerson(String userId, Long planId) throws BizException;

    /**
     * 测试发送钉钉消息
     * @param userIdList
     * @param msg
     * @return
     */
    Boolean testSendDingMsg(List<String> userIdList, JSONObject msg);

    /**
     * 分页查询
     * @param remoteApprovalPageSheetParam
     * @param userId
     * @return
     */

    PageResponse<RemoteApprovalPageSheetDto> pageSheetList(RemoteApprovalPageSheetParam remoteApprovalPageSheetParam, String userId);
}
