package cn.com.duiba.cloud.manage.service.api.remoteservice.system;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.system.AsyncExportTaskDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.system.RemotePageAsyncExportTaskParam;
import cn.com.duiba.cloud.manage.service.api.model.param.system.RemoteUpdateAsyncExportTaskParam;
import cn.com.duiba.wolf.entity.PageResponse;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 异步导出任务中心remote
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-09-17 10:48
 * @since 2.0.8
 **/
@AdvancedFeignClient
public interface RemoteAsyncExportTaskService {
    /**
     * 分页查询异步导出任务列表
     *
     * @param param 请求参数
     * @return 异步导出任务列表
     */
    PageResponse<AsyncExportTaskDTO> pageListAsyncExportTask(RemotePageAsyncExportTaskParam param);

    /**
     * 根据任务id查询导出文件地址
     *
     * @param createBy 任务创建者
     * @param taskId   任务id
     * @return 导出地址
     * @throws BizException 业务异常
     */
    String getExportFileUrlByTaskId(@NotNull(message = "任务创建者不能为空") Long createBy
            , @NotNull(message = "任务id不能为空") Long taskId) throws BizException;

    /**
     * 创建异步导出任务
     *
     * @param taskName 任务名称
     * @param operator 创建人
     * @return 任务id
     */
    Long createTask(@NotBlank(message = "任务名称不能为空") String taskName
            , @NotNull(message = "创建人不能为空") Long operator);

    /**
     * 更新异步导出任务
     *
     * @param param 请求参数
     * @return 布尔值
     */
    Boolean updateTask(RemoteUpdateAsyncExportTaskParam param);

    /**
     * 创建处理完成的任务
     * @param taskName 任务名
     * @param operator 操作人
     * @param taskType 任务类型
     * @return
     */
    Long createFinishTask(@NotBlank(message = "任务名称不能为空") String taskName
            , @NotNull(message = "创建人不能为空") Long operator
            ,@NotBlank(message = "任务类型不能为空") String taskType
            ,@NotBlank(message = "跳转地址不能为空") String jumpUrl);
}
