package cn.com.duiba.cloud.manage.service.api.model.enums;

import cn.com.duiba.boot.exception.BizException;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description 处理类型枚举
 * @date 2021/11/9 14:18
 */
public enum DealTypeEnum {

    /**
     *
     */
    AGREE(1, "同意加入"),
    DISAGREE(2, "不同意加入")
    ;

    private final Integer code;
    private final String desc;

    DealTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DealTypeEnum getByCode(Integer code) throws BizException {
        for (DealTypeEnum subEnum : DealTypeEnum.values()) {
            if (subEnum.getCode().equals(code)) {
                return subEnum;
            }
        }
        throw new BizException("用户操作类型错误，范围[1, 2]");
    }
}
