package cn.com.duiba.cloud.manage.service.api.remoteservice.datav;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.area.OverviewDataDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.area.RetailAuthDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.area.SaleRadioDataDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.area.YearSaleScheduleDto;

import java.util.List;

/**
 * @Description 一地一策V5
 * @Date 2023/5/23 13:55
 * @Author LuHui
 */
@AdvancedFeignClient
public interface RemoteAreaPlanV5Service {

    /**
     * 查询年度销售进度
     * @param provinceCode
     * @param cityCode
     * @return
     */
    YearSaleScheduleDto getYearScheduleSaleData(String provinceCode, String cityCode);

    /**
     * 统计利群价类百分比
     *
     * @param provinceCode
     * @param cityCode
     * @return
     */
    List<SaleRadioDataDto> statisticLiQunSalePriceTypeRadio(String provinceCode , String cityCode);

    /**
     * 总览数量
     * @param provinceCode
     * @param cityCode
     * @return
     */
    OverviewDataDto getOverviewData(String provinceCode, String cityCode);

    /**
     * 近六个月零售户认证数量
     * @param provinceCode
     * @param cityCode
     * @return
     */
    List<RetailAuthDto> getRecentlySixMonthRetailAuthData(String provinceCode, String cityCode);
}
