package cn.com.duiba.cloud.manage.service.api.remoteservice.datav;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.product.CigarettePriceDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.product.CigarettePurchasersDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.product.YearSaleTargetDto;

import java.util.List;

/**
 * @Author: nongfu
 * @Date: 2023/5/23-21:59
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteDatavProductService {

    /**
     * 通过商品规格 和城市查询code
     * @param tobaId 品规id
     * @param code
     * @return
     */
    YearSaleTargetDto getSaleAndTargetByCodeAndCar(String tobaId,String code);


    /**
     * 获取零售户数和可订货数
     * @param tobaId
     * @param code
     * @return
     */
    List<CigarettePurchasersDto> getCigarettePurchasers(String tobaId, String code);


    /**
     * 查询价格与存销比
     * @param tobaId
     * @param code
     * @return
     */
    List<CigarettePriceDto> getCigarettePrice(String tobaId, String code);


    void  testTask(Integer type);

}
