package cn.com.duiba.cloud.manage.service.api.remoteservice.datav;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.area.SaleDto;

import java.util.List;

/**
 * @Description 导入销售数据
 * @Date 2023/5/22 16:38
 * @Author LuHui
 */
@AdvancedFeignClient
public interface RemoteDatavSaleDataService {


    /**
     * 导入销售数据
     *
     * @param year
     * @param origin
     * @param saleDtoList
     */
    void importSaleData(String year, Integer origin, List<SaleDto> saleDtoList);

    /**
     * 测试同步零售商认证数据
     */
    void testSyncRetailAuthData();

    /**
     * 测试同步销售价类数据
     */
    void testSyncSalePriceTypeData();

    void deleteRedisData(String key);

    void setRedisData(String key, String value, Long expireTime);
}
