package cn.com.duiba.cloud.manage.service.api.utils;

import lombok.extern.slf4j.Slf4j;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;

/**
 * @author xuanyu
 * @description:
 * @date 2022/8/26 10:31 AM
 */
@Slf4j
public class GetFieldUtil {
    public static <T,R> String getFieldName(SFunction<T,R> fn){
        try {
            Method writePlace = fn.getClass().getDeclaredMethod("writeReplace");
            //看看是否可以外部访问,true代表方法是public
            boolean accessible = writePlace.isAccessible();
            writePlace.setAccessible(true);
            //invoke第一个参数方法持有者的对象,第二个参数是方法需要的参数
            SerializedLambda serializedLambda = (SerializedLambda) writePlace.invoke(fn);
            //因为更改后java会缓存,下次再调用还是true,对其他地方也生效,所以需要重置回去
            writePlace.setAccessible(accessible);
            String name = serializedLambda.getImplMethodName().substring(3);
            name = name.replaceFirst(String.valueOf(name.charAt(0)), String.valueOf(name.charAt(0)).toLowerCase());
            return name;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 拼接keyword
     * @param key
     * @return
     */
    public static String keyword(String key){
        return key+".keyword";
    }

}
