package cn.com.duiba.cloud.manage.service.api.model.dto.report;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 公众号阅读量
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@SuppressWarnings("all")
public class WechatPageReadDTO implements Serializable {
    private static final long serialVersionUID = 1102718850533441228L;

    private Date curDate;
    /**
     * '阅读次数'
     */
    private Long intPageReadCount;
    /**
     * '阅读人数'
     */
    private Long intPageReadUser;

    /**
     * '分享次数'
     */
    private Long shareCount;

    /**
     * '分享人数'
     */
    private Long shareUser;

    /**
     * '阅读原文次数'
     */
    private Long oriPageReadCount;

    /**
     * '阅读原文人数'
     */
    private Long oriPageReadUser;

    /**
     * '收藏次数'
     */
    private Long addToFavCount;

    /**
     * '收藏人数'
     */
    private Long addToFavUser;

    /**
     * '群发篇数'
     */
    private Long articleSummary;

    /**
     * '渠道:99999999.全部；0:会话;1.好友;2.朋友圈;3.腾讯微博;4.历史消息页;5.其他;6.看一看;7.搜一搜；'
     */
    private Long userSource;
}
