package cn.com.duiba.cloud.manage.service.api.remoteservice.datav;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.area.*;

import java.util.List;

/**
 * @Description 一地一策V5
 * @Date 2023/5/23 13:55
 * @Author LuHui
 */
@AdvancedFeignClient
public interface RemoteAreaPlanV5Service {

    /**
     * 查询时间进度
     * @return
     */
    List<DataScheduleDto> getScheduleData();

    /**
     * 查询年度销售进度
     * @param adCode
     * @param type
     * @return
     */
    List<YearSaleScheduleDto> getYearScheduleSaleData(String adCode, String type);

    /**
     * 统计利群价类百分比
     *
     * @param adCode
     * @param type
     * @return
     */
    List<SaleRadioDataDto> statisticLiQunSalePriceTypeRadio(String adCode, String type);

    /**
     * 总览数量
     * @param adCode
     * @param type
     * @return
     */
    List<OverviewDataDto> getOverviewData(String adCode, String type);

    /**
     * 近六个月零售户认证数量
     * @param adCode
     * @param type
     * @return
     */
    List<RetailAuthDto> getRecentlySixMonthRetailAuthData(String adCode, String type);

    /**
     * 近7周销售结构数据
     * @param adCode
     * @param type
     * @return
     */
    List<CigSaleStructureDto> getRecentlySevenWeekSaleStructureData(String adCode, String type);

    /**
     * 获取市场售价
     * @param adCode
     * @param type
     * @param cigBarCode
     * @return
     */
    List<DataVCommDto> getMarketSalePrice(String adCode, String type, String cigBarCode);

    /**
     * 获取品规相关零售户
     * @param adCode
     * @param type
     * @param cigBarCode
     * @return
     */
    List<DataVCommDto> getCigRetail(String adCode, String type, String cigBarCode);
}
