package cn.com.duiba.cloud.manage.service.api.remoteservice.upcoming;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.upcoming.OperationRecordDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.upcoming.UpcomingDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.upcoming.UpcomingDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.upcoming.UpcomingFlowDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteArrangeWorkParam;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteCreateUpcomingParam;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteEditUpcomingFlowParam;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteEditUpcomingParam;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteGetUpcomingParam;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteInitiateUpcomingParam;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteListOperationRecordParam;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteListUpcomingFlowParam;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteListUpcomingParam;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteStaffAssignmentParam;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteUpcomingProcessParam;
import cn.com.duiba.cloud.manage.service.api.model.param.upcoming.RemoteWorkingArrangementsParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author xuanyu
 * @description:
 * @date 2022/11/10 2:46 PM
 */
@AdvancedFeignClient
public interface RemoteUpcomingService {

    /**
     * 根据待办流id查询
     * @param upcomingFlowId
     * @return
     */
    UpcomingFlowDTO getUpcomingFlowById(Long upcomingFlowId);

    /**
     * 查询待办流列表
     * @param remoteListUpcomingFlowParam
     * @return
     */
    PageResponse<UpcomingFlowDTO> listUpcomingFlow(RemoteListUpcomingFlowParam remoteListUpcomingFlowParam);

    /**
     * 根据id批量查询待办流信息
     * @param upcomingFlowIdList
     * @return
     */
    List<UpcomingFlowDTO> listUpcomingFlowByIds(List<Long> upcomingFlowIdList);

    /**
     * 更新待办流
     * @param remoteEditUpcomingFlowParam
     */
    void updateUpcomingFlow(RemoteEditUpcomingFlowParam remoteEditUpcomingFlowParam);

    /**
     * 待办事项列表
     * @param remoteListUpcomingParam
     * @return
     */
    PageResponse<UpcomingDTO> listUpcomingDTO(RemoteListUpcomingParam remoteListUpcomingParam);

    /**
     * 发起待办
     * @param remoteInitiateUpcomingParam
     */
    void initiateUpcoming(RemoteInitiateUpcomingParam remoteInitiateUpcomingParam) throws BizException;

    /**
     * 新建待办
     * @param remoteCreateUpcomingParam
     * @return
     */
    Long createUpcoming(RemoteCreateUpcomingParam remoteCreateUpcomingParam) throws BizException;

    /**
     * 查询待办详情
     * @param remoteGetUpcomingParam
     * @return
     */
    UpcomingDetailDTO getUpComingDetail(RemoteGetUpcomingParam remoteGetUpcomingParam) throws BizException;

    /**
     * 删除待办
     * @param upcomingId
     */
    void deleteUpcoming(Long upcomingId) throws BizException;

    /**
     * 编辑待办
     * @param remoteEditUpcomingParam
     */
    void updateUpcoming(RemoteEditUpcomingParam remoteEditUpcomingParam) throws BizException;

    /**
     * 分配执行人员工作
     * @param remoteStaffAssignmentParam
     * @return
     */
    Long staffAssignments(RemoteStaffAssignmentParam remoteStaffAssignmentParam) throws BizException;

    /**
     * 工作安排/调整安排
     * @param remoteArrangeWorkParam
     */
    void arrangeWork(RemoteArrangeWorkParam remoteArrangeWorkParam) throws BizException;

    /**
     * 完成工作
     * @param remoteWorkingArrangementsParam
     */
    void completeWork(RemoteWorkingArrangementsParam remoteWorkingArrangementsParam) throws BizException;

    /**
     * 查询操作记录
     * @param remoteListOperationRecordParam
     */
    PageResponse<OperationRecordDTO> listOperationRecord(RemoteListOperationRecordParam remoteListOperationRecordParam);

    /**
     * 待办流程递进
     * @param remoteUpcomingProcessParam
     */
    void upcomingProcess(RemoteUpcomingProcessParam remoteUpcomingProcessParam) throws BizException;

    /**
     * 删除待办人员
     * @param remoteStaffAssignmentParam
     */
    void deleteStaffAssignments(RemoteStaffAssignmentParam remoteStaffAssignmentParam) throws BizException;
}
