package cn.com.duiba.cloud.manage.service.api.model.dto.plan;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Date 2022/9/14 15:38
 * @Author LuHui
 */
@Data
public class RemoteYearPlanDto implements Serializable {
    private static final long serialVersionUID = -1361315572441418906L;

    /**
     * 计划id
     */
    private Long id;

    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * 版块id
     */
    private Long templateId;
    /**
     * 版块名称
     */
    private String templateName;
    /**
     * 排序
     */
    private Long sort;

    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动开始时间
     */
    private Date startTime;
    /**
     * 活动结束时间
     */
    private Date endTime;
    /**
     * 活动品规
     */
    private List<String> regulateList;
    /**
     * 部门
     */
    private List<String> departmentList;
    /**
     * 活动负责人
     */
    private List<RemoteDutyPersonDto> dutyPersonVoList;
    /**
     * 状态
     */
    private Integer status;

    /**
     * 零售户入网数
     */
    private String saleAccessNum;
    /**
     * 消费者获客
     */
    private String consumerAcquireNum;
    /**
     * 零售户活动交互
     */
    private String saleJoinNum;
    /**
     * 消费者活动交互
     */
    private String consumerJoinNum;
    /**
     * 推文宣传交互
     */
    private String tweetJoinNum;
    /**
     * 策划推广费用
     */
    private String planExtendCost;
    /**
     * 市场营销烟合计(万元)
     */
    private String marketCigarettesCost;
    /**
     * 市场营销烟合计(条)
     */
    private String marketCigarettesTotal;
    /**
     * 营销物资合计
     */
    private String marketGoodNum;
    /**
     * 快递合计(单数)
     */
    private String expressTotal;
    /**
     * 快递合计(万元)
     */
    private String expressCost;
    /**
     * 零售户交互人均单价
     */
    private String saleJoinAvg;
    /**
     * 消费者交互人均单价
     */
    private String consumerJoinAvg;
    /**
     * 推文交互人均单价
     */
    private String tweetJoinAvg;

    /**
     * 零售户新增入网（万户）
     */
    private String addSaleAccessNum;
    /**
     * 获客新增关注（万人）
     */
    private String newAttentionCustomer;
    /**
     * KPI运营交互量（万人次）
     */
    private String kpiOperationInteraction;
}
