package cn.com.duiba.cloud.manage.service.api.model.enums.plan;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @Description 审批、抄送
 * @Date 2022/11/8 17:28
 * @Author LuHui
 */
public enum ApprovalTypeEnum {

    APPROVAL(0, "审批"),
    SEND(1, "抄送"),
    ;


    private Integer code;

    private String desc;

    ApprovalTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static ApprovalTypeEnum getApprovalByType(Integer type){
        if (Objects.isNull(type)){
            return null;
        }
        return Stream.of(ApprovalTypeEnum.values()).filter(x -> Objects.equals(x.getCode(), type)).findFirst().orElse(null);
    }
}
