package cn.com.duiba.cloud.manage.service.api.model.dto.risk;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author: LuHui
 * @date: 2023/6/30 17:03
 * @description:
 */
@Data
public class RiskAreaDto implements Serializable {
    private static final long serialVersionUID = 712403891544174834L;

    /**
     * 风控区域坐标集合
     */
    private List<RiskAreaPointDto> areaPointList;
    /**
     * 风控区域分布集合
     */
    private List<RiskAreaScopeDto> areaScopeList;

    @Data
    public static class RiskAreaPointDto implements Serializable {
        private static final long serialVersionUID = 1L;
        /**
         * 经度
         */
        private String longitude;
        /**
         * 纬度
         */
        private String latitude;
    }

    @Data
    public static class RiskAreaScopeDto implements Serializable {
        private static final long serialVersionUID = 1L;
        /**
         * 最大经度
         */
        private String maxLongitude;
        /**
         * 最小经度
         */
        private String minLongitude;
        /**
         * 最大纬度
         */
        private String maxLatitude;
        /**
         * 最小纬度
         */
        private String minLatitude;
    }
}
