package cn.com.duiba.cloud.manage.service.api.model.dto.terminal;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/7/6 10:43
 **/
@Getter
@Setter
@ToString
public class RetailerProgressDTO implements Serializable {

    /**
     * 主键
     */
    private Long id;
    /**
     * 零售户id
     */
    private Long retailerId;
    /**
     * 订单id
     */
    private String orderId;

    /**
     * 订单类型
     */
    private Integer orderType;
    /**
     *
     */
    private Long terminalId;
    /**
     * 零售户进度状态
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.terminal.RetailerStateEnum
     */
    private Integer state;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 地址id
     */
    private Long addressId;
    /**
     * 物流单号
     */
    private String logisticsNo;
    /**
     * 物流公司
     */
    private String logisticsName;
    /**
     * 获客进度, 0 未绑码，1 已绑码
     */
    private Integer acquireState;

    /**
     * 周期开始时间
     */
    private Date cycleStartTime;

    /**
     * 周期结束时间
     */
    private Date cycleEndTime;

    /**
     * 自建二维码id
     */
    private Long qrcodeId;
}
