/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.utils;

import cn.com.duiba.wolf.utils.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private static final SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");

    public static Date getCurrentYearStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(2, 0);
        todayStart.set(5, 1);
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    public static Date getHalfYearStartTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        if (currentMonth >= 1 && currentMonth <= 6) {
            c.set(2, 0);
        } else if (currentMonth >= 7 && currentMonth <= 12) {
            c.set(2, 6);
        }
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getCurrentQuarterStartTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        if (currentMonth >= 1 && currentMonth <= 3) {
            c.set(2, 0);
        } else if (currentMonth >= 4 && currentMonth <= 6) {
            c.set(2, 3);
        } else if (currentMonth >= 7 && currentMonth <= 9) {
            c.set(2, 4);
        } else if (currentMonth >= 10 && currentMonth <= 12) {
            c.set(2, 9);
        }
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getCurrentMonthStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(5, 1);
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    public static Date getWeekStart() {
        Date today = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        int weekday = c.get(7);
        if (weekday == 1) {
            return DateUtils.getDayStartTime((Date)DateUtils.daysAddOrSub((Date)today, (int)-6));
        }
        return DateUtils.getDayStartTime((Date)DateUtils.daysAddOrSub((Date)today, (int)(2 - weekday)));
    }

    public static Date getHourTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    public static Date getDayTime(int offSetDay) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.add(5, offSetDay);
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    public static Date getEndTime(int offSetDay) {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.add(5, offSetDay);
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime();
    }

    public static Integer getCurrentTime() {
        return new Long(System.currentTimeMillis() / 1000L).intValue();
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.getSecondStr((Date)DateUtil.getHourTime()));
        System.out.println(DateUtils.getSecondStr((Date)DateUtil.getDayTime(0)));
        System.out.println(DateUtils.getSecondStr((Date)DateUtil.getDayTime(-1)));
        System.out.println(DateUtils.getSecondStr((Date)DateUtil.getCurrentMonthStartTime()));
        System.out.println(DateUtils.getSecondStr((Date)DateUtil.getCurrentQuarterStartTime()));
        System.out.println(DateUtils.getSecondStr((Date)DateUtil.getHalfYearStartTime()));
        System.out.println(DateUtils.getSecondStr((Date)DateUtil.getCurrentYearStartTime()));
    }
}

