package cn.com.duiba.cloud.manage.service.api.model.enums.plan;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @Description 审批单需求开发
 * @Date 2022/11/4 16:39
 * @Author LuHui
 */
public enum ApprovalBusinessDevelopEnum {
    BUSINESS_ONE(1, "系统开发"),
    BUSINESS_TWO(2, "测试选项1"),
    BUSINESS_THREE(3, "测试选项2"),
    ;

    private Integer id;

    private String name;

    ApprovalBusinessDevelopEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static ApprovalBusinessDevelopEnum getById(Integer id){
        if (Objects.isNull(id)){
            return null;
        }
        return Stream.of(ApprovalBusinessDevelopEnum.values()).filter(x -> Objects.equals(x.getId(), id)).findFirst().orElse(null);
    }
}
