package cn.com.duiba.cloud.manage.service.api.model.enums.system;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 导入导出任务枚举
 *
 * @author nongfu
 * @Date 2022/10/27 13:57
 */
@Getter
@AllArgsConstructor
public enum TaskNameEnum {

    EXPORT_PLAN_DATA_REFLOW(1, 0, "运营计划导出数据回流"),
    IMPORT_PLAN(2, 1, "导入运营计划"),
    FLEXIBLE_REPORT(3, 0,"导出灵活报表"),
    EXPORT_APPROVAL_SHEET(4, 0, "导出审批流"),
    EXPORT_YEAR_PLAN(5, 0, "导出年度计划"),
    EXPORT_QUARTER_PLAN(6, 0, "导出季度计划"),
    EXPORT_YEAR_PLAN_REVIEW(7, 0, "导出年度计划总览"),

    EXPORT_CHEAT_LOG(8, 0, "导出撞库明细"),
    EXPORT_BLACK_WHITE(9, 0, "导出黑灰名单"),

    EVENT_OPERATIONS_PLAN(10, 1, "导入营销活动计划"),
    TWITTER_PROMOTION(11, 1, "导入推文宣传计划"),
    MONTH_PLAN(12, 1, "导入月度计划"),

    ZGD_RISK(13, 0, "导出风控记录"),

    EXPORT_SALE_CHECK(16, 0, "导出入网审核"),
    EXPORT_SALE_APPEAL(17, 0, "导出入网申诉")

    ;


    private Integer code;
    /**
     * 导入为1 导出为 0
     */
    private Integer type;

    private String text;

}
