package cn.com.duiba.cloud.manage.service.api.remoteservice.report;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.ProvinceConsumerDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.ProvinceRetailerDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.RegionConsumerDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.RegionRetailerDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.report.BusinessReportParam;

import java.util.List;

/**
 * 业务报表 定时同步返回数据
 *
 * @author zouwx
 * @date 2022/03/17
 */
@AdvancedFeignClient
public interface RemoteBusinessTaskService {

    /**
     * 业务方 浙江省内数据 零售入网
     *
     * @param param 参数
     * @return 省份数据
     * @throws BizException 业务异常
     */
    ProvinceRetailerDTO provinceQuery(BusinessReportParam param) throws BizException;

    /**
     * 业务方 大区数据 零售入网
     *
     * @param param 参数
     * @return 任务ID
     * @throws BizException 业务异常
     */
    List<RegionRetailerDTO> regionQuery(BusinessReportParam param) throws BizException;


    /**
     * 业务方报表 浙江省内数据 消费者
     *
     * @param param 参数
     * @return 任务ID
     * @throws BizException 业务异常
     */
    ProvinceConsumerDTO consumerProvinceQuery(BusinessReportParam param) throws BizException;


    /**
     * 业务方报表 大区数据 消费者
     *
     * @param param 参数
     * @return 任务ID
     * @throws BizException 业务异常
     */
    List<RegionConsumerDTO> consumerRegionQuery(BusinessReportParam param) throws BizException;

}
