package cn.com.duiba.cloud.manage.service.api.remoteservice.sms;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.enums.sms.VerificationSceneEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.sms.SendVerificationParam;

@AdvancedFeignClient
public interface RemoteSmsVerifyService {

    /**
     * 短信验证码校验
     * @param phone 手机号
     * @param value 验证码
     * @param scene 场景
     * @throws BizException 异常
     */
    void verification(String phone, String value, VerificationSceneEnum scene) throws BizException;

    /**
     * 发送短信验证码
     * 短信模板仅支持缓存5分钟
     * 同时发送间隔1分钟
     * @param param 业务参数
     * @return 对应的验证码
     * @throws BizException 异常
     */
    String sendMessage(SendVerificationParam param) throws BizException;


}
