package cn.com.duiba.cloud.manage.service.api.remoteservice.tag;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.tag.TagGroupUserDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.tag.TagUserGroupDto;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.group.RemoteGroupQueryConnectParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.group.RemoteTagUserGroupDelParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.group.RemoteTagUserGroupParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.group.RemoteUserGroupPageQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/3/7
 */
@AdvancedFeignClient
public interface RemoteTagUserGroupService {

    /**
     * 创建用户群
     * @param param
     * @return
     */
    Long create(RemoteTagUserGroupParam param) throws BizException;

    /**
     * 更新用户群
     * @param param
     * @return
     */
    Boolean update(RemoteTagUserGroupParam param) throws BizException;

    /**
     * 删除用户群
     * @param param
     * @return
     */
    Boolean del(RemoteTagUserGroupDelParam param);

    /**
     * 查询详情
     * @param id
     * @return
     */
    TagUserGroupDto detail(Long id);

    /**
     * 分页查询用户群信息
     * @param param
     * @return
     */
    PageResponse<TagUserGroupDto> queryList(RemoteUserGroupPageQueryParam param);

    /**
     * 查询关联列表
     * @param param
     * @return
     */
    List<TagGroupUserDto> queryConnectList(RemoteGroupQueryConnectParam param);

    /**
     * 分页查询
     * @param param
     * @return
     */
    PageResponse<TagGroupUserDto> queryConnectListPage(RemoteGroupQueryConnectParam param);

    /**
     * 根据id列表查询 (查询的用户群信息)
     * @param idList
     * @return
     */
    List<TagUserGroupDto> queryByIdList(List<Long> idList);

    /**
     * 根据userId查询已关联列表
     * @param userIdList 用户id list
     * @return List<TagGroupUserDto>
     */
    List<TagGroupUserDto> queryByUserIdList(List<Long> userIdList);

    /**
     * 根据id list查询客户群-用户关联关系
     * @param idList 关系id list
     * @return List<TagGroupUserDto>
     */
    List<TagGroupUserDto> queryTagGroupUserByIdList(List<Long> idList);

    /**
     * 根据id list查询客户群-用户关联关系
     * @param list 群组id list
     * @return List<TagGroupUserDto>
     */
    List<TagGroupUserDto> queryTagGroupUserByGroupIdList(List<Long> list);
}
