package cn.com.duiba.cloud.manage.service.api.model.dto.report.export;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description 黑灰名单管理
 * @Date 2022/12/14 17:34
 * @Author LuHui
 */
@Data
public class ExportBlackWhiteData implements Serializable {
    private static final long serialVersionUID = 5281059635344848681L;

    /**
     * openId
     */
    @ExcelProperty(value = "openId")
    private String openId = "/";

    /**
     * 用户类型
     */
    @ExcelProperty(value = "用户类型")
    private String userType = "/";

    /**
     * 用户名称
     */
    @ExcelProperty(value = "用户名称")
    private String userName = "/";

    /**
     * 手机号
     */
    @ExcelProperty(value = "手机号")
    private String phoneNum = "/";

    /**
     * 是否关注 1：关注 0：未关注
     */
    @ExcelProperty(value = "关注状态")
    private String subscribe = "/";

    /**
     * 加入时间
     */
    @ExcelProperty(value = "加入名单时间")
    private String time = "/";

    /**
     * 撞库时的名单类型 1：黑 2：灰
     */
    @ExcelProperty(value = "名单类型")
    private String cheatType = "/";

    /**
     * 撞库次数
     */
    @ExcelProperty(value = "撞库次数")
    private Long cheatLogCount = 0L;

    @ExcelProperty(value = "来源")
    private String originStr;


    @ExcelProperty(value = "省")
    private String province;


    @ExcelProperty(value = "城市")
    private String city;

    @ExcelProperty(value = "地区")
    private String area;

    @ExcelProperty(value = "详细地址")
    private String address;



}
