package cn.com.duiba.cloud.manage.service.api.model.dto.report.export;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xuanyu
 * @description: 平和星余额报表导出
 * @date 2022/7/19 2:03 PM
 */
@Data
public class ExportPeaceRemainData implements Serializable {
    private static final long serialVersionUID = -6288408001568321832L;
    /**
     * 日期
     */
    @ExcelProperty("日期")
    private String currentDateStr;

    /**
     * 小于等于600
     */
    @ExcelProperty("平和星余额0-600人数")
    private Long underSixHundred;

    /**
     * 小于等于1200
     */
    @ExcelProperty("平和星余额601-1200人数")
    private Long underOneThousndTwoHundred;

    /**
     * 小于等于1800
     */
    @ExcelProperty("平和星余额1201-1800人数")
    private Long underOneThousandEightHundred;

    /**
     * 小于等于2400
     */
    @ExcelProperty("平和星余额1801-2400人数")
    private Long underTwoThousandFourHundred;

    /**
     * 小于等于3000
     */
    @ExcelProperty("平和星余额2401-3000人数")
    private Long underThreeThousand;

    /**
     * 小于等于3600
     */
    @ExcelProperty("平和星余额3001-3600人数")
    private Long underThreeThousandSixHundred;

    /**
     * 大于3600
     */
    @ExcelProperty("平和星余额3601及以上人数")
    private Long aboveThreeThousandSixHundred;
}
