package cn.com.duiba.cloud.manage.service.api.model.dto.report.export;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author: LuHui
 * @date: 2023/8/28 16:58
 * @description:
 */
@Data
public class ExportSaleCheckData implements Serializable {
    private static final long serialVersionUID = 55438718985764048L;


    /**
     * 审核单id
     */
    @ExcelProperty(value = "审核单ID", index = 0)
    private Long id;
    /**
     * 审核类型
     */
    @ExcelProperty(value = "审核类型", index = 1)
    private String checkType;
    /**
     * 头像
     */
    @ExcelProperty(value = "用户头像", index = 2)
    private String avatar;

    /**
     * 用户名
     */
    @ExcelProperty(value = "用户名称", index = 3)
    private String username;

    /**
     * 手机号
     */
    @ExcelProperty(value = "手机号", index = 4)
    private String mobile;
    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名", index = 5)
    private String name;
    /**
     * 店铺名称
     */
    @ExcelProperty(value = "店铺名称", index = 6)
    private String shopName;
    /**
     * 所属地区
     */
    @ExcelProperty(value = "所属地区", index = 7)
    private String address;

    /**
     * 审核单状态;1:待审核 2:审核通过 3:审核拒绝
     */
    @ExcelProperty(value = "审核状态", index = 8)
    private String checkStatus;

    /**
     * 专卖证号
     */
    @ExcelProperty(value = "专卖证号", index = 9)
    private String saleCertificateNo;

    /**
     * 已等待时间
     */
    @ExcelProperty(value = "已等待时间", index = 10)
    private String waitTime;

    /**
     * 提交时间
     */
    @ExcelProperty(value = "提交时间", index = 11)
    private String submitTime;
    /**
     * 审核时间
     */
    @ExcelProperty(value = "审核时间", index = 12)
    private String checkTime;
}
