package cn.com.duiba.cloud.manage.service.api.model.dto.report.export;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author: LuHui
 * @date: 2023/7/17 14:34
 * @description:
 */
@Data
public class ZgdRiskRecordData implements Serializable {
    private static final long serialVersionUID = 3808458822397692832L;

    /**
     * 用户id
     */
    @ExcelProperty(index = 0)
    private String userId;

    /**
     * openId
     */
    @ExcelProperty(index = 1)
    private String openId;

    /**
     * 游戏次数
     */
    @ExcelProperty(index = 2)
    private Integer gameTimes;

    /**
     * 邀请助力次数
     */
    @ExcelProperty(index = 3)
    private Integer inviteAssistTimes;

    /**
     * 抽奖次数
     */
    @ExcelProperty(index = 4)
    private Integer drawTimes;

    /**
     * 获奖次数
     */
    @ExcelProperty(index = 5)
    private Integer acquirePrizeTimes;

    /**
     * 签到次数
     */
    @ExcelProperty(index = 6)
    private Integer signTimes;

    /**
     * 参与活动次数
     */
    @ExcelProperty(index = 7)
    private String joinActivityTimes;

    /**
     * 每日参与次数
     */
    @ExcelProperty(index = 8)
    private String dayJoinTimes;

    /**
     * 绑定收获地址数量
     */
    @ExcelProperty(index = 9)
    private Integer bindAddressNum;

    /**
     * 绑定收获人个数
     */
    @ExcelProperty(index = 10)
    private Integer bindTakePrizePersonNum;

    /**
     * 绑定手机号个数
     */
    @ExcelProperty(index = 11)
    private Integer bindPhoneNum;

    /**
     * 同时兑奖用户数
     */
    @ExcelProperty(index = 12)
    private Integer sameTimeTakePrizeUserNum;

    /**
     * 空间收获地址风险等级
     */
    @ExcelProperty(index = 13)
    private Integer spaceAddressRiskLevel;

    /**
     * 文本收获地址风险等级
     */
    @ExcelProperty(index = 14)
    private Integer textAddressRiskLevel;

    /**
     * FC模型得分
     */
    @ExcelProperty(index = 15)
    private String pcModelScore;

    /**
     * 随机森林模型得分
     */
    @ExcelProperty(index = 16)
    private String randomForestModelScore;

    /**
     * SVM模型得分
     */
    @ExcelProperty(index = 17)
    private String svmModelScore;

    /**
     * XGBoost模型得分
     */
    @ExcelProperty(index = 18)
    private String xgBoostModelScore;

    /**
     * Isolation Forest模型得分
     */
    @ExcelProperty(index = 19)
    private String isolationForestModelScore;

    /**
     * 游戏次数(仅统计因子)得分
     */
    @ExcelProperty(index = 20)
    private String gameTimesStatisticScore;

    /**
     * 邀请助力次数(仅统计因子)得分
     */
    @ExcelProperty(index = 21)
    private String inviteAssistTimesStatisticScore;

    /**
     * 抽奖次数(仅统计因子)得分
     */
    @ExcelProperty(index = 22)
    private String drawTimesStatisticScore;

    /**
     * 获奖次数(仅统计因子)得分
     */
    @ExcelProperty(index = 23)
    private String acquirePrizeTimesStatisticScore;

    /**
     * 签到次数(仅统计因子)得分
     */
    @ExcelProperty(index = 24)
    private String signTimesStatisticScore;

    /**
     * 参与活动数(仅统计因子)得分
     */
    @ExcelProperty(index = 25)
    private String joinActivityTimesStatisticScore;

    /**
     * 每日参与次数(仅统计因子)得分
     */
    @ExcelProperty(index = 26)
    private String dayJoinTimesStatisticScore;

    /**
     * 绑定收获地址数量(仅统计因子)得分
     */
    @ExcelProperty(index = 27)
    private String bindAddressNumStatisticScore;

    /**
     * 绑定收获人个数(仅统计因子)得分
     */
    @ExcelProperty(index = 28)
    private String bindTakePrizePersonNumStatisticScore;

    /**
     * 绑定手机号个数(仅统计因子)得分
     */
    @ExcelProperty(index = 29)
    private String bindPhoneNumStatisticScore;

    /**
     * 同时兑奖用户数(仅统计因子)得分
     */
    @ExcelProperty(index = 30)
    private String sameTimeTakePrizeUserNumStatisticScore;

    /**
     * TOPSIS(仅统计因子)得分
     */
    @ExcelProperty(index = 31)
    private String topSisStatisticScore;

    /**
     * 空间收获地址风险等级(仅高级因子)得分
     */
    @ExcelProperty(index = 32)
    private String spaceAddressRiskLevelHighScore;

    /**
     * 文本收获地址风险等级(仅高级因子)得分
     */
    @ExcelProperty(index = 33)
    private String textAddressRiskLevelHighScore;


    /**
     * TOPSIS(仅高级因子)得分
     */
    @ExcelProperty(index = 34)
    private String topSisHighScore;

    /**
     * 游戏次数(全部因子)得分
     */
    @ExcelProperty(index = 35)
    private String gameTimesAllScore;

    /**
     * 邀请助力次数(全部因子)得分
     */
    @ExcelProperty(index = 36)
    private String inviteAssistTimesAllScore;

    /**
     * 抽奖次数(全部因子)得分
     */
    @ExcelProperty(index = 37)
    private String drawTimesAllScore;

    /**
     * 获奖次数(全部因子)得分
     */
    @ExcelProperty(index = 38)
    private String acquirePrizeTimesAllScore;

    /**
     * 签到次数(全部因子)得分
     */
    @ExcelProperty(index = 39)
    private String signTimesAllScore;

    /**
     * 参与活动数(全部因子)得分
     */
    @ExcelProperty(index = 40)
    private String joinActivityTimesAllScore;

    /**
     * 每日参与次数(全部因子)得分
     */
    @ExcelProperty(index = 41)
    private String dayJoinTimesAllScore;

    /**
     * 绑定收获地址数量(全部因子)得分
     */
    @ExcelProperty(index = 42)
    private String bindAddressNumAllScore;

    /**
     * 绑定收货人个数(全部因子)得分
     */
    @ExcelProperty(index = 43)
    private String bindTakePrizePersonNumAllScore;

    /**
     * 绑定手机号个数(全部因子)得分
     */
    @ExcelProperty(index = 44)
    private String bindPhoneNumAllScore;

    /**
     * 同时兑奖用户数(全部因子)得分
     */
    @ExcelProperty(index = 45)
    private String sameTimeTakePrizeUserNumAllScore;

    /**
     * 空间收货地址风险等级(全部因子)得分
     */
    @ExcelProperty(index = 46)
    private String spaceAddressRiskLevelAllScore;

    /**
     * 文本收货地址风险等级(全部因子)得分
     */
    @ExcelProperty(index = 47)
    private String textAddressRiskLevelAllScore;

    /**
     * TOPSIS(全部因子)得分
     */
    @ExcelProperty(index = 48)
    private String topSisAllScore;

    /**
     * 总风险得分
     */
    @ExcelProperty(index = 49)
    private String totalRiskScore;
}
