package cn.com.duiba.cloud.manage.service.api.model.dto.risk;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: LuHui
 * @date: 2023/7/4 14:02
 * @description:
 */
@Data
public class RiskRecordDto implements Serializable {
    private static final long serialVersionUID = -5722035403438169170L;
    /**
     * 风控检测文件
     */
    public static final String EXT_RISK_FILE = "riskFileList";
    /**
     * 风控检测回调文件
     */
    public static final String EXT_RISK_CALLBACK_FILE = "riskCheckCallbackFile";



    /**
     * 主键
     */
    private Long id;

    /**
     * 业务id
     */
    private String bizId;

    /**
     * 三方业务id
     */
    private String thirdBizId;

    /**
     * 类型 0:风险校验 1:模型训练
     */
    private Integer type;

    /**
     * 状态 0:初始化 1:发送成功 2:回调成功 3:处理成功 4:处理失败
     */
    private Integer status;

    /**
     * 操作人id
     */
    private String operateId;

    /**
     * 额外字段
     */
    private String extraJson;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
