package cn.com.duiba.cloud.manage.service.api.model.enums.exception;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName ErrorCode.java
 * @Description 异常返回枚举
 * @createTime 2021年07月14日 14:55:00
 */
public enum ErrorCode {
    /**
     * 999开头为系统级异常
     */
    ERROR("999999", "未知异常"),
    REQUEST_FREQUENTLY("999998", "请求过于频繁，请稍后再试"),
    EXTERNAL_INTERFACE_INVOKE_FAIL("999997", "外部接口调用失败，请稍后再试"),
    FILE_SIZE_OUT_LIMIT("999996", "文件大小超过限制"),
    NEED_LONGIN("000000", "请先登录"),
    UNKNOWN_OPERATOR("0000001", "未知操作人"),
    FAULTY_PAGINATION_PARAM("0000002", "不正确的分页参数"),
    PARAM_IS_NOT_NULL("0000003", "必填参数不能为空"),
    TENANT_COOKIE_INVALID("0000004", "企业cookie已失效"),
    UPDATE_TEL_FAIL("0000005", "手机号已注册，请重新输入"),
    FILE_NOT_EXISTS("0000006", "文件不存在"),
    UPLOAD_EXCEL_FILE("0000007", "请上传正确的EXCEL文件，以.xls或.xlsx结尾"),
    ERROR_PARAM("0000008", "参数错误"),
    PARAM_NOT_SPECIFICATION("0000009", "[]字段输入不合规"),
    CAPTCHA_ERROR("0000010", "图片验证码错误"),
    EMAIL_ERROR("0000011", "邮箱格式错误"),
    CAPTCHA_VALIDATE_FAIL("0000012", "验证码校验不通过"),
    NOT_UPDATE_DEFAULT_PASSWORD("0000013", "请修改初始密码"),
    INFO_NOT_INCOMPLETE("0000015", "待验证登录信息不完善"),
    CREATE_ACCOUNT_ERROR("0000016", "创建账号异常"),
    OSS_BUCKET_NOT_EXIST("0000017", "oss上传失败，bucket【[]】不存在"),
    OLD_NEW_PASSWORD_EQUAL("0000018", "新旧密码不能相同"),
    MOBILE_ERROR("0000019", "人员手机号码输入不合规"),
    ACCOUNT_ERROR("0000020", "账号不可用"),
    QUERY_DAY_OUT_OF_RANGE("0000021", "只能查询最近[]天的数据"),
    OLD_PASSWORD_ERROR("0000022", "旧密码校验失败"),
    E0100001("0100001", "密码即将过期，请及时修改"),
    E0100002("0100002", "密码长度不少于8位，不大于16位，至少包含字母，数字，特殊字符。"),
    E0100003("0100003", "密码已过期，请联系管理员重置密码"),
    SEND_VERIFICATION_MAX("0200001", "发送间隔达到上限"),
    SEND_SMS_NUMBER_MAX("0200002", "今日发送次数达到上限制"),
    SMS_CODE_ERROR("0200003", "验证码错误"),
    ACCOUNT_LOCK("0200004", "账号已被锁定, 请联系管理员解锁账号"),
    ACCOUNT_THREE_TIME_FAIL("0200005","连续失败5次账号会被锁定，请谨慎操作或联系管理员重置密码"),
    PASSWORD_ERROR("0200006", "账号或密码错误"),
    PHONE_NOT_EXIST("0200007", "手机号不存在，请联系管理员添加"),

    //================企业开始100开头================================
    TENANT_NOT_NULL("100001", "请先选择企业"),
    TENANT_NAME_EXIST("100002", "企业名称已存在"),
    TENANT_NAME_NOT_BLANK("100003", "企业名称不能为空"),
    TENANT_NOT_EXIST("100004", "企业不存在"),
    TENANT_CREATE_LIMIT("100005", "企业创建已达上限"),
    TENANT_SAVE_FAIL("100006", "保存企业失败"),
    TENANT_UPDATE_FAIL("100007", "更新企业失败"),


    //================企业结束======================================


    //================部门开始101开头================================
    /**
     * 部门名称不能为空
     */
    DEPT_NAME_NOT_BLANK("101001", "部门名称不能为空"),
    CHILD_DEPT_IS_MAX("101002", "子部门数量已经达到最大值,无法继续创建"),
    DEPT_NAME_EXIST("101003", "部门名称已存在"),
    CHILD_DEPT_LEVEL_MAX("101004", "最多可以创建[]级子部门"),
    DEPT_NOT_EXIST("101005", "部门不存在"),
    DEPT_STAFF_EXIST("101006", "部门下存在有效用户，无法删除"),
    P_DEPT_ID_NOT_NULL("101007", "上级部门id不能为空"),
    DEPT_NOT_NULL("101008", "部门不能为空"),
    DEPT_NULL_NOT_EXIST("101009", "部门名称[]不存在"),
    PARENT_DEPT_NOT_SELF("101010", "上级部门不能是自身"),
    PARENT_DEPT_FOR("101011", "部门上下级发生循环"),
    DEPT_STAFF_IDENTIFY_NOT_EXIST("101012", "部门员工身份不存在"),
    P_DEPT_ID_IS_NULL("1010013", "上级部门[id]不存在"),
    //================部门结束======================================

    //================角色开始102开头================================
    ROLE_ID_NOT_NULL("102001", "角色id不能为空"),
    ROLE_NAME_NOT_BLANK("102002", "角色名称不能为空"),
    ROLE_NOT_EXISTS("102003", "角色信息不存在"),
    DEFAULT_ROLE_CAN_NOT_DELETE("102004", "不允许删除默认角色"),
    ROLE_HAS_STAFF("102005", "所删除角色下存在用户，请删除用户后再尝试"),
    DEFAULT_ROLE_CAN_NOT_UPDATE("102006", "不允许操作默认角色"),
    ROLE_NAME_REPEAT("102007", "角色名称重复"),
    ROLE_NOT_NULL("102008", "角色不能为空"),
    ROLE_NAME_NOT_EXISTS("102009", "角色名称[]不存在"),
    ROLE_EXISTS_STAFF("102010", "员工已存在该角色"),

    ROLE_AUTH_INSERT_FAIL("102198", "角色权限信息创建失败"),
    ROLE_UPDATE_FAIL("102097", "角色更新失败"),
    ROLE_INSERT_FAIL("102098", "角色创建失败"),
    ROLE_DELETE_FAIL("102099", "角色删除失败"),
    //================角色结束======================================

    //================员工开始103开头================================
    STAFF_NOT_EXIST("103001", "员工不存在"),
    STAFF_IS_NULL("103002", "未选择员工"),
    ADMINISTRATOR_NOT_EXIST("103003", "管理员不存在"),
    STAFF_IS_EXIST("103004", "员工已存在，可于“员工管理”中修改"),
    STAFF_INVITE_RECORD_IS_EXIST("103005", "员工已经邀请，不可重复导入"),
    STAFF_UPDATE_TEL_FAIL("103006", "更新手机号失败"),
    STAFF_SAVE_FAIL("103007", "保存企业员工失败"),
    STAFF_UPDATE_FAIL("103008", "更新企业员工失败"),
    STAFF_EXIT_FAIL("103009", "退出企业失败"),
    ADMIN_STAFF_NOT_DEL("103010", "管理员不允许被删除"),
    STAFF_INVITE_NOT_EXIST("103011", "员工邀请不存在"),
    STAFF_INVITE_NOT_USE("103012", "员工邀请已失效"),
    DUPLICATE_STAFF("103013", "员工选择重复"),
    ADMINISTRATOR_CAN_NOT_EXIT("103014", "管理员不允许退出企业"),
    STAFF_POSITION_NAME_TOO_LONG("103015", "员工岗位名称字段信息过长，须小于[]个字符"),
    DEPT_NAMES_TOO_LONG("103016", "部门字段字段信息过长，须小于[]个字符"),
    STAFF_USER_ID_TOO_LONG("103017", "员工编号字段信息过长，须小于[]个字符"),
    STAFF_NAME_TOO_LONG("103018", "员工名称字段信息过长，须小于[]个字符"),
    STAFF_LEAST_NEED_ONE_ROLE("103019", "员工至少需要保留一个角色"),
    STAFF_USER_ID_NOT_EMPTY("103020", "员工编号不能为空"),
    INVITE_STAFF_FAIL("103021", "邀请员工失败"),

    STAFF_ROLE_INSERT_FAIL("103198", "角色员工添加失败"),
    STAFF_ROLE_DELETE_FAIL("103199", "角色员工删除失败"),
    STAFF_HAS_EXITED("103200", "员工已退出企业"),
    //================员工结束======================================

    //================应用开始104开头================================
    APP_ID_NOT_NULL("104001", "应用id不能为空"),
    APP_CODE_NOT_BLANK("104002", "应用code不能为空"),
    APP_SUBSCRIBE_FAIL("104003", "应用订阅失败"),
    APP_NOT_EXISTS("104004", "应用不存在"),
    APP_AUTH_NOT_BLANK("104005", "应用权限不能为空"),
    DUPLICATE_APP("104006", "请勿选择重复应用"),
    TENANT_NOT_SUBSCRIBE_APP("104007", "企业未订阅应用"),
    //================应用结束======================================

    //================邀请记录开始105开头================================
    INVITE_NOT_EXIST("105001", "邀请记录不存在"),
    ACCEPT_INVITE_FAIL("105002", "接受邀请失败"),
    REJECT_INVITE_FAIL("105003", "拒绝邀请失败"),
    STAFF_INVITE_REMAKE_TOO_LONG("105004", "备注字段信息过长，须小于[]个字符"),

    //================应用结束======================================

    //================权限开始106开头================================
    AUTH_ID_NOT_NULL("106001", "权限id不能为空"),
    AUTH_CODE_NOT_BLANK("106002", "权限code不能为空"),
    AUTH_NAME_NOT_BLANK("106003", "权限名称不能为空"),
    AUTH_TYPE_NOT_RIGHT("106004", "权限类型不正确"),
    AUTH_CODE_EXISTS("106005", "当前应用权限code已存在"),
    AUTH_NAME_EXISTS("106006", "同级别权限name已存在"),
    AUTH_NOT_EXISTS("106007", "权限不存在"),
    HAS_SUB_AUTH("106008", "存在子权限，不可删除"),
    AUTH_LIST_NOT_NULL("106009", "权限列表不能为空"),
    AUTH_SORT_NOT_NULL("106010", "权限序号不能为空"),
    PARENT_AUTH_NOT_EXISTS("106011", "父级权限不存在"),
    DUPLICATE_AUTH("106012", "权限重复"),

    AUTH_DELETE_FAIL("106197", "删除权限失败"),
    AUTH_INSERT_FAIL("106198", "新增权限失败"),
    AUTH_UPDATE_FAIL("106199", "权限更新失败"),
    //================权限结束======================================
    //================文件导入开始107开头================================
    HANDLER_IS_NULL("107001", "暂不支持导入,导入类型[]"),
    IMPORT_DATA_TYPE_IS_NULL("107002", "暂不支持导入"),
    IMPORT_NOT_EMPTY("107003", "导入数据不能为空"),
    IMPORT_OVERTAKE_MAX("107004", "导入数据不能超过[]条"),
    //================文件导入结束======================================
    //================文件导入开始108开头================================
    USER_IS_NULL("108001", "员工编号不存在"),
    USER_ID_DUPLICATE("108003", "员工编号重复"),
    USER_NOT_BELONG_TENANT("108004", "非本企业人员"),

    NAME_IS_BLANK("108006", "员工名称不能为空"),
    USERID_IS_BLANK("108007", "员工编号为空"),
    DATA_IS_EMPTY("108009", "没有查询到可以导出的数据"),
    STAFF_USER_ID_REPEAT("108010", "员工编号[]在文件中重复"),
    USERID_ERROR("108011", "员工编号格式错误,只支持数字或者字母"),
    EXPORT_DATA_TYPE_ERROR("108012", "暂不支持导出"),
     // 计划
    ACTIVITY_NAME_IS_ERROR("108020", "请输入正确的活动描述"),

    ACTIVITY_PLATE_IS_ERROR("108021", "请输入正确的运营项目"),
    ACTIVITY_BUSINESS_UNIT("108022", "请输入正确的业务单元"),

    //================文件导入结束======================================
    //================权益开始109开头================================
    RIGHTS_NAME_NOT_BLANK("109001", "权益名称不能为空"),
    RIGHTS_CODE_NOT_BLANK("109002", "权益code不能为空"),
    RIGHTS_LEVEL_NOT_BLANK("109003", "权益优先级不能为空"),
    DUPLICATE_RIGHTS_LEVEL("109004", "相同权益code不可存在相同的level"),
    DUPLICATE_RIGHTS_NAME("109005", "同级别下权益名称不允许重复"),
    RIGHTS_ID_NOT_NULL("109006", "权益id不能为空"),
    RIGHTS_NOT_EXISTS("109007", "权益不存在"),
    HAS_SON_RIGHTS("109008", "存在子权益，不可删除"),
    PARENTS_ID_NOT_EXISTS("109009", "父权益不存在"),
    RIGHTS_INFO_NOT_EMPTY("109010", "权益信息不能为空"),
    RIGHTS_SORT_NOT_NULL("109011", "权益序号不能为空"),
    RIGHTS_IS_ALREADY_SUBSCRIBE("109012", "权益已被订阅"),

    RIGHTS_AUTH_SAVE_FAIL("109089", "权益权限保存失败"),
    RIGHTS_SAVE_FAIL("109099", "权益保存失败"),
    RIGHTS_UPDATE_FAIL("109098", "权益更新失败"),
    RIGHTS_DELETE_FAIL("109097", "权益删除失败"),
    //================权益导入结束======================================

    //================标签相关110开头======================================
    TAG_NOT_EXIST("110001", "标签不存在"),
    TAG_ALREADY_DELETE("110002", "标签已删除"),
    TAG_GROUP_NOT_EXIST("110003", "标签组不存在"),
    TAG_GROUP_EXIST("110005", "存在同名标签组"),
    TAG_GROUP_ALREADY_DELETE("110004", "标签组已删除"),
    TAG_GROUP_ADD_ERROR("110006", "标签组创建失败"),
    TAG_EXIST("110007", "存在同名标签"),
    TAG_WECHAT_ADD_ERROR("110008", "微信标签创建失败"),

    //================标签相关结束======================================

    //================供应商相关201开头======================================
    NO_ADDRESS_MAPPING("201001", "该商品暂不支持配送至当前区域"),
    UN_SUPPORT_SUPPLIER("201002", "暂不支持当前供应商"),
    GOODS_NOT_EXISTS("201003", "商品信息不存在"),
    CATEGORY_NOT_EMPTY("201004", "商品缺少类目信息"),
    //================供应商相关结束======================================

    //================导入活动数据301======================================
    AWARD_TIME_NOT_BLANK("301001", "用户领奖时间不能为空"),
    ORDER_CODE_NOT_BLANK("301002", "订单编号不能为空"),
    OPEN_ID_NOT_BLANK("301003", "用户id不能为空"),
    GOODS_TITLE_NOT_BLANK("301004", "商品标题不能为空"),
    ORDER_STATE_NOT_BLANK("301005", "订单状态不能为空"),
    PROVINCE_NOT_BLANK("301006", "省不能为空"),
    CITY_NOT_BLANK("301007", "市不能为空"),
    AREA_NOT_BLANK("301008", "区不能为空"),
    STREET_NOT_BLANK("301009", "街道不能为空"),
    DELIVERY_INFO_NOT_BLANK("301010", "收货信息不能为空"),
    NAME_NOT_BLANK("301011", "姓名不能为空"),
    PHONE_NOT_BLANK("301012", "手机号不能为空"),
    DELIVERY_NO_NOT_BLANK("301013", "快递单号不能为空"),

    //================导入活动数据结束======================================

    //================签到活动301开始======================================
    NOT_ACTIVITY_ERROR("301001", "活动信息获取异常"),

    //================签到活动301结束======================================

    //=====================陈列投票活动302开始 =========================
    VOTE_TIME_ERROR("302001", "开始时间不能小于结束时间"),
    VOTE_BETWEEN_TIME_ERROR("302002","时间间隔不能超过30天"),

    VOTE_INFO_IS_EMPTY("302003","参数异常"),

    VOTE_USER_INFO_EMPTY("302004","用户信息获取异常"),

    VOTE_UPDATE_IS_FAIL("302005","审核修改失败"),

    CAN_NOT_VERIFY("302010","当前记录非待审核状态不能审核"),

//=====================陈列投票活动302结束 =========================

    //================运营计划401开始======================================
    PLAN_TEMPLATE_EXIST("400001", "和其他名称重复，请重命名"),
    PLAN_TEMPLATE_NOT_EXIST("400002", "活动版块不存在"),
    PLAN_TEMPLATE_NOT_REMOVE("400003", "活动版块无法移动"),
    PLAN_NOT_EXIT("400004", "活动不存在"),
    NOT_OPEN_CLOSE("400005", "已结束无法开启或关闭计划"),
    PLAN_ALREADY_CLOSE("400006", "已结束无法操作"),
    PLAN_ALREADY_END("400007", "已结束无法操作"),
    CREATE_APPROVAL_PLAN_END("400008", "计划已结束无法发起审批"),
    CREATE_APPROVAL_DUTY_PERSON("400009", "计划负责人才能发起审批"),
    CREATE_APPROVAL_ENABLE("400010", "审批流禁用状态无法发起审批"),
    CREATE_APPROVAL_ERROR("400011", "创建审批单失败"),
    RE_CREATE_ERR1("400012", "被重发的审批单无法重发"),
    RE_CREATE_ERR2("400013", "审批失败的审批单才能重发"),
    RE_CREATE_ERR3("400014", "审批单重发失败"),
    APPROVAL_NOT_COMMENT("400015", "评论失败，请刷新页面"),

    APPROVAL_IS_NULL("400020", "非法操作"),

    APPROVAL_FLOW_SAME_STATE("400021", "状态值相同"),

    APPROVAL_FLOW_FORBID("400022", "有进行中的审批不能编辑"),
    APPROVAL_FLOW_ID("400023", "审批单信息异常"),

    APPROVAL_FLOW_IS_COMPLETE("400024", "该审批单已完成"),

    APPROVAL_FLOW_NODE_IS_COMPLETE("400025", "已有人审批完成，无需再次审批"),
    APPROVAL_FLOW_IS_DEAL("400026", "您已经审批过了"),



    //================签到活动301结束======================================


    ;

    private String code;

    private String msg;

    ErrorCode(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}