package cn.com.duiba.cloud.manage.service.api.model.enums.sms;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public enum VerificationSceneEnum {

    LOGIN(1, "登录"),

    ;

    private Integer scene;

    private String desc;

    VerificationSceneEnum(Integer scene, String desc) {
        this.scene = scene;
        this.desc = desc;
    }

    private static Map<Integer, VerificationSceneEnum> map = new HashMap<Integer, VerificationSceneEnum>() {{
        for (VerificationSceneEnum sceneEnum : VerificationSceneEnum.values()) {
            put(sceneEnum.getScene(), sceneEnum);
        }
    }};

    public static VerificationSceneEnum getByScene(Integer scene) {
        return map.get(scene);
    }
}
