package cn.com.duiba.cloud.manage.service.api.model.param.terminal;

import cn.com.duiba.cloud.manage.service.api.model.constant.RegexpConst;
import cn.com.duiba.cloud.manage.service.api.model.param.PageBaseParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/26 15:36
 */
@Getter
@Setter
public class RemoteTerminalStaffExecPageParam extends PageBaseParam {

    /**
     * 活动id
     */
    @NotNull(message = "活动id不能为空")
    private Long activityId;

    /**
     * 终端业务员姓名
     */
    @Size(max = 50, message = "终端业务员姓名最大50个字符")
    private String name;

    /**
     * 终端业务员手机号
     */
    @Pattern(regexp = RegexpConst.PHONE, message = "手机格式错误")
    private String phone;

    /**
     * 地区code
     */
    private List<String> addressCode;
}
