/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.model.dto.importdata;

import cn.com.duiba.cloud.manage.service.api.model.dto.importdata.BaseImportData;
import com.alibaba.excel.annotation.ExcelProperty;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ImportSaveSupplierGoodsData
extends BaseImportData {
    private static final long serialVersionUID = 7916701336717920157L;
    @ExcelProperty(value={"\u5546\u54c1\u7f16\u7801\uff08\u7b2c\u4e09\u65b9skuId\uff09"})
    private String sku;
    @ExcelProperty(value={"\u5e93\u5b58"})
    private String stock;
    @ExcelProperty(value={"\u6210\u672c\u4ef7"})
    private String price;
    @ExcelProperty(value={"\u5bfc\u5165\u7ed3\u679c"})
    private String result;
    private static final Integer MAX_SKU_SIZE = 50;

    public boolean dataCheck() {
        if (StringUtils.isBlank((CharSequence)this.getSku())) {
            this.setErrorMessage("\u5546\u54c1\u7f16\u7801\u672a\u586b\u5199");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.getStock())) {
            this.setErrorMessage("\u5e93\u5b58\u672a\u586b\u5199");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.getPrice())) {
            this.setErrorMessage("\u6210\u672c\u4ef7\u672a\u586b\u5199");
            return false;
        }
        if (this.getSku().length() > MAX_SKU_SIZE) {
            this.setErrorMessage("\u5546\u54c1\u7f16\u7801\u683c\u5f0f\u9519\u8bef");
            return false;
        }
        if (!Pattern.matches("^[1-9]\\d{0,8}|0$", this.getStock())) {
            this.setErrorMessage("\u5e93\u5b58\u683c\u5f0f\u9519\u8bef");
            return false;
        }
        if (!Pattern.matches("^([1-9]\\d{0,5}|0)(\\.\\d{1,2})?$", this.getPrice())) {
            this.setErrorMessage("\u6210\u672c\u4ef7\u683c\u5f0f\u9519\u8bef");
            return false;
        }
        return true;
    }

    public String getSku() {
        return this.sku;
    }

    public String getStock() {
        return this.stock;
    }

    public String getPrice() {
        return this.price;
    }

    public String getResult() {
        return this.result;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public void setStock(String stock) {
        this.stock = stock;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public void setResult(String result) {
        this.result = result;
    }
}

