package cn.com.duiba.cloud.manage.service.api.model.param.terminal;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/7/21 15:22
 **/
@Getter
@Setter
public class RemoteTerminalReportRecordUpdateParam implements Serializable {

    /**
     * 终端业务员id
     */
    @NotNull(message = "终端业务员id不能为空")
    private Long terminalId;
    /**
     * 活动id
     */
    @NotNull(message = "活动id不能为空")
    private Long activityId;
    /**
     * 零售户id
     */
    @NotNull(message = "零售户id不能为空")
    private Long retailerId;
    /**
     * 审核状态
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.audit.AuditStateEnum
     */
    private Integer state;
    /**
     * 是否发放物资
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.terminal.DistributeTypeEnum
     */
    private Integer distribute;
    /**
     * 审核状态
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.audit.AuditStateEnum
     */
    private Integer auditState;
}
