package cn.com.duiba.cloud.manage.service.api.model.dto.importdata;

import cn.com.duiba.cloud.manage.service.api.model.constant.RegexpConst;
import cn.hutool.core.util.ReUtil;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/30 10:08
 */
@Getter
@Setter
public class ImportTerminalStaffData extends BaseImportData {

    /**
     * 员工编号
     */
    @ExcelProperty("员工编号")
    private String num;

    /**
     * 终端人员姓名
     */
    @ExcelProperty("终端人员姓名")
    private String name;

    /**
     * 终端人员手机号
     */
    @ExcelProperty("终端人员手机号")
    private String phone;

    /**
     * 省份
     */
    @ExcelProperty("省份")
    private String province;

    /**
     * 地市
     */
    @ExcelProperty("地市")
    private String city;

    /**
     * 校验数据，并且塞进去错误原因
     *
     * @return 是否通过校验
     */
    public boolean dataCheck() {
        // check员工编号格式
        boolean isMatch = StringUtils.isNotBlank(getNum()) && ReUtil.isMatch(RegexpConst.NUMBER_LETTER, getNum())
                && getNum().length() <= 30;
        if (!isMatch) {
            setErrorMessage("员工编号限字母或数字格式，长度不超过30个字符串");
            return false;
        }

        // check 姓名
        isMatch = StringUtils.isNotBlank(getName()) && getName().length() <= 30;
        if (!isMatch) {
            setErrorMessage("可输入不超过30字符");
            return false;
        }

        // check 手机号
        isMatch = StringUtils.isNotBlank(getPhone()) && ReUtil.isMatch(RegexpConst.PHONE, getPhone());
        if (!isMatch) {
            setErrorMessage("仅限输入11位国内手机号");
            return false;
        }

        // check 省份
        isMatch = StringUtils.isNotBlank(getProvince());
        if (!isMatch) {
            setErrorMessage("省份不能为空");
            return false;
        }

        return true;
    }
}
