package cn.com.duiba.cloud.manage.service.api.model.enums.report;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.Getter;

/**
 * @author xuanhongjian
 */
@Getter
public enum  RetailerChannelEnum {
    //分类数据 零售户来源 为 邀请注册：SOURCE = 2
    //零售户来源 为 菜单主动注册：SOURCE = 1
    //零售户来源 为 自律互助：SOURCE = 5
    //零售户来源 为 小组联盟：SOURCE = 6
    //零售户来源 为 获客 或 获客初始化：SOURCE  in (3,-2)
    //零售户来源 为 拆条 或 橙中支扫码 或 拆条初始化 ：SOURCE  in (4,7,-1)
    //零售户来源 为 软蓝陈列：SOURCE = 8
    MENU_REGISTER(1,"菜单主动注册"),
    INVITE(2,"邀请注册"),
    SELF_DISCIPLINE(5,"自律互助"),
    GROUP_ALLIANCE(6,"小组联盟"),
    GET_CUSTOMERS(3,"获客"),
    GET_CUSTOMERS_INIT(-2,"获客初始化"),
    STRIP(-1,"拆条初始化"),
    STRIP_INIT(4,"拆条"),
    ZZZ_SCAN_CODE(7,"橙中支扫码"),
    SOFT_BLUE(8,"软蓝陈列"),
    UNKNOWN(-100,"未知");
    private final Integer code;
    private final String desc;

     RetailerChannelEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final ImmutableMap<Integer, RetailerChannelEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, RetailerChannelEnum> builder = ImmutableMap.builder();
        for (RetailerChannelEnum item : RetailerChannelEnum.values()) {
            builder = builder.put(item.getCode(), item);
        }
        INNER_MAP = builder.build();
    }
    public static RetailerChannelEnum getByCode(Integer code) {
        return Objects.isNull(code) ? UNKNOWN : INNER_MAP.get(code);
    }
}
