package cn.com.duiba.cloud.manage.service.api.model.enums.staff;

import java.util.Objects;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description 员工身份枚举
 * @date 2021/11/8 10:41
 */
public enum StaffIdentityEnum {

    /**
     *
     */
    ADMINISTRATOR(0, "企业管理员"),
    GENERAL(1, "普通用户")
    ;

    private final Integer code;
    private final String desc;

    StaffIdentityEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    public static StaffIdentityEnum getEnum(Integer code){
        for (StaffIdentityEnum value : StaffIdentityEnum.values()) {
            if (Objects.equals(value.code,code)){
                return value;
            }
        }
        return null;
    }
}
